; This program is free software; you can redistribute it and/or modify

; it under the terms of the GNU General Public License as published by

; the Free Software Foundation
; either version 2 of the License, or

; (at your option) any later version.

;
; This program is distributed in the hope that it will be useful,

; but WITHOUT ANY WARRANTY
; without even the implied warranty of

; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

; GNU General Public License for more details.


;; Command is installed in " "Save all layers with a palette as bmp..."

;;
;; A template string should be provided which fits the form: prefix~~~~.ext

;; where prefix is a character string (optionally null).

;;       ~~~~ represents the digits of the frame number, one ~ per digit

;;       ext is the filename extension (which also specifies the format)

;; the tildas are optional and four digits will be assumed if omitted.

;; an extension of .png is assumed if one is not provided

;; the period is significant, if PNG is not to be assumed

;;;; the "Use Current (not implemented)" option uses "Make Optimal Palette" by now


(define (save-all-layers-with-palette
			orig-image
			drawable
			template
			rename?
			
			str_PathName
			int_PaletteGenerationMethode
			str_Palette
			int_StretchPalette
			;int_ChMethode
			ext?
			)
  
(define (get-all-layers img)
    (let* (
        (all-layers (gimp-image-get-layers img))
        (i (car all-layers))
        (bottom-to-top ())
        )
      (set! all-layers (cadr all-layers))
      (while (> i 0)
        (set! bottom-to-top (append bottom-to-top (cons (aref all-layers (- i 1)) '())))
        (set! i (- i 1))
        )
      bottom-to-top
      )
    )
  (define (save-layer orig-image layer name)
   

(let* (
        (image 0)
        (buffer "")
        (int_UsePMethode 0)
	)
      	
	(if (= int_PaletteGenerationMethode 1)
		(begin
			(set! int_PaletteGenerationMethode 4)
			(set! str_Palette (car (gimp-context-get-palette)))
		)
	)
		
	(set! int_UsePMethode int_PaletteGenerationMethode) 
				;This is because UseCurrentPalette is not implemented yet	
		
	

	(set! buffer (car (gimp-edit-named-copy layer "temp-copy")))
     	(set! image (car (gimp-edit-named-paste-as-new buffer)))
    
	(when (and (not (= (car (gimp-image-base-type image)) INDEXED))
                 (string-ci=? (car (last (strbreakup name "."))) "bmp"))
		
      
	
	
	
	
	(gimp-image-convert-indexed 
					image
					NO-DITHER
					int_UsePMethode
					int_StretchPalette
					FALSE
					FALSE
					str_Palette
					) 
					;;The type of palette to use { MAKE-PALETTE (0), WEB-PALETTE (2), MONO-PALETTE (3), CUSTOM-PALETTE (4)
					;;A type of '1' means to re-use the previous palette (not currently implemented). 
        
      (gimp-file-save RUN-NONINTERACTIVE image (car (gimp-image-get-active-layer image)) name name)
      (gimp-buffer-delete buffer)
      (gimp-image-delete image)
      )
 )
)
  (let* (
      (layers nil)
      (fullname "")
      (basename "")
      (layername "")
      (format "")
      (layerpos 1)
      (framenum "")
      (settings "")
      (default-extension "bmp")
      (extension "bmp")
      (orig-selection 0)
      )
    (gimp-image-undo-disable orig-image)
    (set! orig-selection (car (gimp-selection-save orig-image)))
    (gimp-selection-none orig-image)

    (set! extension (strbreakup template "."))
    (set! extension (if (> (length extension) 1)
                      (car (last extension))
                      default-extension))
    ;;(when (= (string-length extension) 0)
    ;;  (set! default-extension "bmp"))
    (when (= rename? TRUE)
      (set! format (strbreakup template "~"))
      (if (> (length format) 1)
        (begin
          (set! basename (car format))
          (set! format (cdr format))
          (set! format (cons "" (butlast format)))
          (set! format (string-append "0" (unbreakupstr format "0")))
          )
        (begin
          (set! basename (car (strbreakup template ".")))
          (set! format "0000")
          
	)
        )
      )
    (set! layers (get-all-layers orig-image))
    (while (pair? layers)
      (if (= rename? TRUE)
        (begin
          (set! framenum (number->string layerpos))
          (set! framenum (string-append
                (substring format 0 (- (string-length format)
                                       (string-length framenum))) framenum))
          (set! fullname (string-append basename framenum))
          )
        (begin
          (set! fullname (car (strbreakup
                           (car (gimp-item-get-name (car layers))) "(")))
          
	  ;(gimp-message fullname)
		
	  (gimp-item-set-name (car layers) fullname)
          (set! fullname (car (gimp-item-get-name (car layers))))

          )
        )
	(if (= ext? TRUE)
		(begin
      		(set! fullname (string-append fullname "." extension))
		;(gimp-message fullname)
		)	
	)
      (save-layer orig-image (car layers) (string-append (string-append str_PathName "/") fullname))
      (set! layers (cdr layers))
      (set! layerpos (+ layerpos 1))
      )
    ;(gimp-image-select-item orig-selection int_ChMethode 0)
    (gimp-image-remove-channel orig-image orig-selection)
    (gimp-image-undo-enable orig-image)
    )
  )

(script-fu-register 
 "save-all-layers-with-palette"
 "Save all layers with a palette as bmp..."
 "Save all layers to a bmp file."
 "MarKus Rietz"
 "MarkusRietz, GNU"
 "23/08/2011"
 ""
 SF-IMAGE    "Image"    0
 SF-DRAWABLE "Drawable" 0
 SF-STRING "Name Template (~ replaced by layer position)" "frame_~~~~.bmp"
 SF-TOGGLE "Rename (ex: 'frame__0001')" FALSE
 
 SF-DIRNAME "Path" "C:/Users/Public/Pictures/" 
 SF-OPTION "Palette Generation Methode"	'("Make Optimal Palette""Use Selected Palette""Make Web Palette""Make B/W Palette""Assign Custom Palette")
 SF-PALETTE "Palette""Default"
 SF-ADJUSTMENT  "Stretch palette (only with: Make Optimal Palette needed:)"     '(256 1 256 1 10 0 1)
 ;SF-OPTION "Channel Mthode"	'("Add""Substract""Replace""Intersect")
 SF-TOGGLE "Create new extention?" TRUE
 )


(script-fu-menu-register "save-all-layers-with-palette"
                         "<Image>/File/")

save-all-layers-with-palette()